uniform sampler2D s_tex0;

uniform vec4  cloudColor;
uniform float cloudInvScale;
uniform vec2 cloudSpeed;
uniform float density;
uniform float detailInvScale;
uniform vec2 detailSpeed;
uniform vec2  sunDirection;
uniform float time;
uniform float scale;
uniform float blendScale;

varying vec2 v_texcoord;
varying vec4 v_color;

void main(void)
{
	float py = 1.-v_texcoord.y;
	
	vec2 cloudOffset  = cloudSpeed  * time;
	vec2 detailOffset = detailSpeed * time;
 
	vec2 scaledTexCoord = v_texcoord * scale;

	float a1 = texture2D (s_tex0, (scaledTexCoord + cloudOffset ) * cloudInvScale ).r;
	float a2 = texture2D (s_tex0, (scaledTexCoord + detailOffset) * detailInvScale).g;
   
	vec2 p_sunDirection = sunDirection;
 
	vec4 color = v_color;
 
	float  absorption = 0.0;
	absorption = (texture2D (s_tex0, (scaledTexCoord + p_sunDirection * 0.2 + cloudOffset ) * cloudInvScale ).r +
				  texture2D (s_tex0, (scaledTexCoord + p_sunDirection * 0.2 + detailOffset) * detailInvScale).g)
				+(texture2D (s_tex0, (scaledTexCoord + p_sunDirection * 0.4 + cloudOffset)  * cloudInvScale ).r +
				  texture2D (s_tex0, (scaledTexCoord + p_sunDirection * 0.4 + detailOffset) * detailInvScale).g)
				+(texture2D (s_tex0, (scaledTexCoord + p_sunDirection * 0.6 + cloudOffset)  * cloudInvScale ).r +
				  texture2D (s_tex0, (scaledTexCoord + p_sunDirection * 0.6 + detailOffset) * detailInvScale).g)
				+(texture2D (s_tex0, (scaledTexCoord + p_sunDirection * 0.8 + cloudOffset)  * cloudInvScale ).r +
	 		      texture2D (s_tex0, (scaledTexCoord + p_sunDirection * 0.8 + detailOffset) * detailInvScale).g)
				+(texture2D (s_tex0, (scaledTexCoord + p_sunDirection * 1.0 + cloudOffset)  * cloudInvScale ).r +
				  texture2D (s_tex0, (scaledTexCoord + p_sunDirection * 1.0 + detailOffset) * detailInvScale).g);
  
	color.rgb -= absorption * 0.02;
	color.a = (1.-absorption*0.01) * (a1 + a2);
	color.a *= py/blendScale;
	color.a *= density;
	
	gl_FragColor = color;
}
